import {dataStrategy} from "../dataStrategy";
import {DataExtractor} from "../../../util/dataExtractor";
import excelSerialToJSDate from "../../../util/excelDateToJSDate";


export abstract class abstractDataStrategyRight implements dataStrategy {
    extractor = DataExtractor.getInstance();
    static readonly FILENAME = '寿州古城.xlsx';
    static readonly SHEETNAME = '指挥调度系统';
    static readonly TIMEDIFFERENCE = 8;
    protected eventData;

    constructor() {
        this.eventData = this.readDataFromExcel();
    }


    execute(params?: any): any {
    }

    protected paramsCheck(params) {
        if (!params || !params.query || !params.query.year) {
            throw new Error('Year parameter is required.');
        }
    }

    protected readDataFromExcel() {
        return this.extractor.getData(abstractDataStrategyRight.FILENAME, abstractDataStrategyRight.SHEETNAME);
    }

    protected registerItems(list: string[]) {
        const eventCount: Map<string, number> = new Map();
        list.forEach(event => {
            eventCount.set(event, 0);
        });
        return eventCount;
    }

    protected getListCount(list: string[], target: string, data: any, year: number) {
        const count = this.registerItems(list);
        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['创建时间']);
            const rowYear = rowDate.getFullYear();

            if (rowYear == year) {
                count.set(row[target], count.get(row[target]) + 1);
            }
        });
        return count;
    }

}