import {abstractDataStrategyMid} from "./abstractDataStrategyMid";
import mapToObj from "../../../util/mapToObj";

export class totalEventCountStrategy extends abstractDataStrategyMid {
    execute(): any {
        let eventData = this.extractor.getData(totalEventCountStrategy.fileName, totalEventCountStrategy.sheetName);
        return mapToObj(this.getEventCount(eventData));
    }

    private getEventCount(data: any) {
        const eventCount : Map<string, number> = new Map();
        eventCount.set('全部事件', 0);

        data.forEach(row => {
            eventCount.set(row['处置状态'], (eventCount.get(row['处置状态']) || 0) + 1);
            eventCount.set('全部事件', eventCount.get('全部事件') + 1);
        });

        return eventCount;

    }
}