import excelSerialToJSDate from "../../../util/excelDateToJSDate";
import mapToObj from "../../../util/mapToObj";
import { abstractDataStrategyLeft } from "./abstractDataStrategyLeft";

export class totalVisitorFlowStrategy extends abstractDataStrategyLeft {

    execute(params?: any): any {
        if (!params || !params.query || !params.query.date) {
            throw new Error("Date parameter is required.")
        }
        let sightData = this.extractor.getData(totalVisitorFlowStrategy.FILENAME, totalVisitorFlowStrategy.SHEETNAME);
        return mapToObj(this.getTotalVisitorByDay(sightData, params.query.date));
    }

    private getTotalVisitorByDay(data: any, date: string) {
        const visitorCount: Map<string, number> = new Map();
        visitorCount.set('total', 0);

        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['游玩时间']);
            let rowDateString = '';
            try {
                rowDateString = rowDate.toISOString().split('T')[0];
            }
            catch (e) {
                rowDateString = 'invalid time'
            }
            if (rowDateString === date) {
                visitorCount.set('total', visitorCount.get('total') + 1);
                visitorCount.set(row['订单游客类型'], (visitorCount.get(row['订单游客类型']) || 0) + 1);
            }
        });

        return visitorCount;

    }

}