import excelSerialToJSDate from "../../../util/excelDateToJSDate";
import mapToObj from "../../../util/mapToObj";
import {abstractDataStrategyLeft} from "./abstractDataStrategyLeft";

export class totalVisitorFlowByHourStrategy extends abstractDataStrategyLeft {


    execute(params?: any): any {
        if (!params || !params.query || !params.query.date) {
            throw new Error('Date parameter is required.');
        }
        const sightData = this.extractor.getData(totalVisitorFlowByHourStrategy.FILENAME, totalVisitorFlowByHourStrategy.SHEETNAME);
        return mapToObj(this.getTotalVisitorFlowByHour(sightData, params.query.date));
    }

    private getTotalVisitorFlowByHour(data: any, date: string) {
        const visitorCount: Map<number, number> = new Map();
        for (let hour = 0; hour < 24; hour++) {
            visitorCount.set(hour, 0);
        }

        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['游玩时间']);
            let rowDateString = '';
            try {
                rowDateString = rowDate.toISOString().split('T')[0];
            }
            catch (e) {
                rowDateString = 'invalid time';
            }

            rowDate.setHours(rowDate.getHours() - 8);
            const rowHour = rowDate.getHours();


            if (rowDateString == date) {
                visitorCount.set(rowHour, (visitorCount.get(rowHour) || 0) + 1);
            }
        });
        return visitorCount;
    }

}