/**
 * excelSerialToJSDate.ts
 * 该文件定义了一个函数，用于将 Excel 日期序列号转换为 JavaScript 日期对象。
 */

/**
 * 将 Excel 日期序列号转换为 JavaScript 日期对象。
 * @param serial - Excel 日期序列号。
 * @returns 转换后的 JavaScript 日期对象。
 */

export default function excelSerialToJSDate(serial: number): Date {
    // Excel 时间纪元（1970年1月1日之前的天数）
    const EXCEL_EPOCH = 25569;
    // 每天的毫秒数
    const MS_PER_DAY = 86400000;

    // 将 Excel 日期拆分为整数部分和小数部分
    const days = Math.floor(serial);
    const fractionalDay = serial - days;

    // 转换为毫秒数
    const jsDateMilliseconds = (days - EXCEL_EPOCH) * MS_PER_DAY + fractionalDay * MS_PER_DAY;

    // 返回 JavaScript 日期对象
    return new Date(jsDateMilliseconds);
}