/**
 * eventMonthDistributionStrategy.ts
 * 该文件定义了事件按月分布策略的具体实现。
 */

import {abstractDataStrategyRight} from "./abstractDataStrategyRight";
import mapToObj from "../../../util/mapToObj";
import excelSerialToJSDate from "../../../util/excelDateToJSDate";

/**
 * 事件按月分布策略类，继承自 abstractDataStrategyRight。
 */
export class eventMonthDistributionStrategy extends abstractDataStrategyRight {
    /**
     * 执行事件按月分布策略。
     * @param params - 请求参数，包含年份信息。
     * @returns 事件按月分布计数的对象表示。
     */
    execute(params?: any): any{
        // 检查参数是否有效
        this.paramsCheck(params);

        // 获取指定年份的事件按月分布计数，并转换为对象
        return mapToObj(this.getEventMonthDistribution(this.eventData, params.query.year), "month", "count");
    }

    /**
     * 获取指定年份的事件按月分布计数。
     * @param data - 从数据源提取的数据。
     * @param year - 指定年份。
     * @returns 事件按月分布计数的映射。
     */
    private getEventMonthDistribution(data: any, year: number) {
        const eventCount: Map<number, number> = new Map();
        for (let month = 1; month <= 12; month++) {
            eventCount.set(month, 0);
        }

        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['创建时间']);
            rowDate.setHours(rowDate.getHours() - eventMonthDistributionStrategy.TIMEDIFFERENCE);
            const rowYear = rowDate.getFullYear();
            const rowMonth = rowDate.getMonth();

            if (rowYear == year) {
                eventCount.set(rowMonth + 1, eventCount.get(rowMonth + 1) + 1);
            }
        });
        return eventCount;

    }
}