/**
 * gateStatusStrategy.ts
 * 该文件定义了门状态策略的具体实现。
 */

import { randomStatusGenerator } from "../../../util/randomStatusGenerator";
import mapToObj from "../../../util/mapToObj";
import { abstractDataStrategyLeft } from "./abstractDataStrategyLeft";

/**
 * 门状态策略类，继承自 abstractDataStrategyLeft。
 */
export class gateStatusStrategy extends abstractDataStrategyLeft {
    private gateStatusMap: Map<string, string> = new Map();

    constructor() {
        super();
        // 初始化门状态映射
        this.gateStatusMap.set('通淝门(南门)', '');
        this.gateStatusMap.set('宾阳门(东门)', '');
        this.gateStatusMap.set('定湖门(西门)', '');
        this.gateStatusMap.set('靖淮门(北门)', '');
    }

    /**
     * 执行门状态策略，生成随机的门状态。
     * @returns 门状态的对象表示。
     */
    execute(params?: any): any {
        if (!params || !params.query || !params.query.date) {
            throw new Error("Date parameter is required.")
        }
        this.gateStatusMap.forEach((value, key, map) => {
            map.set(key, randomStatusGenerator.getRandomStatus());
        });

        return mapToObj(this.gateStatusMap);
    }

    /**
     * 获取门状态映射。
     * @returns 门状态映射。
     */
    getGateStatusMap() {
        return this.gateStatusMap;
    }
}
