export function testDateError(strategy) {
    expect(() => strategy.execute()).toThrow("Date parameter is required.");
    expect(() => strategy.execute({})).toThrow("Date parameter is required.");
    expect(() => strategy.execute({ query: {} })).toThrow("Date parameter is required.");
}

export function testSightError(strategy) {
    expect(() => strategy.execute()).toThrow("Date and sight parameters are required.");
    expect(() => strategy.execute({})).toThrow("Date and sight parameters are required.");
    expect(() => strategy.execute({ query: {} })).toThrow("Date and sight parameters are required.");
    expect(() => strategy.execute({ query: { date: '2023-07-01' } })).toThrow('Date and sight parameters are required.');
    expect(() => strategy.execute({ query: { sight: 'SomeSight' } })).toThrow('Date and sight parameters are required.');
}

export function testYearError(strategy) {
    expect(() => strategy.execute()).toThrow("Year parameter is required.");
    expect(() => strategy.execute({})).toThrow("Year parameter is required.");
    expect(() => strategy.execute({ query: {} })).toThrow("Year parameter is required.");
}

export function testStrategy(strategy, params, truthValue) {
    expect(strategy.execute(params)).toEqual(truthValue);
}