/**
 * mapToObj.ts
 * 该文件定义了一个函数，用于将 Map 对象转换为包含 key 和 value 的对象数组。
 */

/**
 * 将 Map 对象转换为包含 key 和 value 的对象数组。
 * @param map - 要转换的 Map 对象。
 * @param keyName - key 属性的名称 (默认为 'key')。
 * @param valueName - value 属性的名称 (默认为 'value')。
 * @returns 转换后的包含自定义 key 和 value 名称的对象数组。
 */
export default function mapToObj(
    map: Map<any, any>, 
    keyName: string = 'key', 
    valueName: string = 'value'
): Array<{ [key: string]: any }> {
    let result: Array<{ [key: string]: any }> = [];
    map.forEach((value, key) => {
        result.push({ [keyName]: key, [valueName]: value });
    });
    return result;
}
