/**
 * gridEventCountStrategy.ts
 * 该文件定义了按网格统计事件数量策略的具体实现。
 */

import {abstractDataStrategyRight} from "./abstractDataStrategyRight";
import mapToObj from "../../../util/mapToObj";

/**
 * 按网格统计事件数量策略类，继承自 abstractDataStrategyRight。
 */
export class gridEventCountStrategy extends abstractDataStrategyRight {

    /**
     * 执行按网格统计事件数量策略。
     * @param params - 请求参数，包含年份信息。
     * @returns 事件数量统计的对象表示。
     */
    execute(params?: any): any {
        // 检查参数是否有效
        this.paramsCheck(params);

        // 定义网格名称列表
        const gridList = ['寿州全域', '八公山景区', '寿县古城'];

        // 目标字段名称
        const target = '网格名称';

        // 获取指定年份的网格事件数量统计，并转换为对象
        return mapToObj(this.getListCountSorted(gridList, target, this.eventData, params.query.year), "gridname", "count");
    }
}