/**
 * eventCategoryCountStrategy.ts
 * 该文件定义了事件类别计数策略的具体实现。
 */

import {abstractDataStrategyRight} from "./abstractDataStrategyRight";
import mapToObj from "../../../util/mapToObj";

/**
 * 事件类别计数策略类，继承自 abstractDataStrategyRight。
 */
export class eventCategoryCountStrategy extends abstractDataStrategyRight {
    /**
     * 执行事件类别计数策略。
     * @param params - 请求参数，包含年份信息。
     * @returns 事件类别计数的对象表示。
     */
    execute(params?: any): any {
        // 检查参数是否有效
        this.paramsCheck(params);

        // 定义网格名称列表
        const eventList = ['咨询', '求助', '预警系统', '投诉', '指挥调度', '建议']

        // 目标字段名称
        const target = '事件类型';

        // 获取指定年份的网格事件数量统计，并转换为对象
        return mapToObj(this.getListCount(eventList, target, this.eventData, params.query.year), "category", "count");
    }
}