/**
 * totalEventCountStrategy.ts
 * 该文件定义了总事件计数策略的具体实现。
 */

import {abstractDataStrategyMid} from "./abstractDataStrategyMid";
import mapToObj from "../../../util/mapToObj";

/**
 * 总事件计数策略类，继承自 abstractDataStrategyMid。
 */
export class totalEventCountStrategy extends abstractDataStrategyMid {

    /**
     * 执行总事件计数策略。
     * @returns 所有事件的计数。
     */
    execute(): any {
        let eventData = this.extractor.getData(totalEventCountStrategy.fileName, totalEventCountStrategy.sheetName);
        return mapToObj(this.getEventCount(eventData), "status", "count");
    }

    /**
     * 获取所有事件计数的映射
     * @param data - 从数据源提取的数据
     * @returns 所有事件计数的映射
     */
    private getEventCount(data: any) {
        const eventCount : Map<string, number> = new Map();
        eventCount.set('全部事件', 0);

        data.forEach(row => {
            eventCount.set(row['处置状态'], (eventCount.get(row['处置状态']) || 0) + 1);
            eventCount.set('全部事件', eventCount.get('全部事件') + 1);
        });

        return eventCount;

    }
}