/**
 * abstractDataStrategyMid.ts
 * 该文件定义了一个抽象类，用于中间数据策略的基础实现。
 */

import {dataStrategy} from "../dataStrategy";
import {DataExtractor} from "../../../util/dataExtractor";

/**
 * 抽象数据策略中间层类，所有具体策略类都需要继承该抽象类。
 */
export abstract class abstractDataStrategyMid implements dataStrategy {
    extractor = DataExtractor.getInstance();
    static readonly fileName = '寿州古城.xlsx';
    static readonly sheetName = '指挥调度系统';

    /**
     * 执行策略的方法，具体实现由子类提供。
     * @param params - 可选参数。
     */
    execute(params?: any): any {
    }

}