import {currentEventStrategy} from "../biz/strategies/middle/currentEventStrategy";
import {testDateError, testStrategy} from "./utils";
import {allEventDataStrategy} from "../biz/strategies/middle/eventDataStrategy";
import {totalEventCountStrategy} from "../biz/strategies/middle/totalEventCountStrategy";

describe('currentEvent test', function () {
    const strategy = new currentEventStrategy();
    it('should throw an error if date parameter is missing', () => {
        testDateError(strategy);
    });

    it('should return the correct values', () => {
        const mockParams = {
            query: {
                date: '2023-01-14'
            }
        };
        const truthValue = {
            pendingEvents: 1,
            processedEvents:1
        }
        testStrategy(strategy, mockParams, truthValue);
    });
});

describe('allEventData test', function () {
    it('should get all data', () => {
        const strategy = new allEventDataStrategy();
        const truthValue = 200;
        const res = strategy.execute();
        expect(res.length).toBe(truthValue);
    });
});

describe('totalEventCount test', function () {
    it('should get correct result', ()=> {
        const strategy = new totalEventCountStrategy();
        const truthValue = {
            '全部事件': 200,
            '处置中': 76,
            '已办结': 41,
            '已处置': 35,
            '待调度': 48
        }
        testStrategy(strategy, '', truthValue);
    })
});