# 寿州古城数据接口
[中文](#中文) [English](#english)
# 中文
## 端点：`/szgc/getdata`
## 参数：
- `content`:
  - 左侧API：
    - sightVisitorFlowByDay
    - gateStatus
    - sightVisitorFlowPerHour
    - guchengLoad
    - totalVisitorFlow
    - totalVisitorFlowByDay
  - 中间API：
    - currentEventStrategy
    - totalEventCount
    - allEvents
  - 右侧API：
    - getEventCountByYear
    - getEventTimeDistribution
    - getEventMonthDistribution
    - getEventCategoryCount
    - getEventSubCategoryCount
    - getEventSourceCount
    - getGridEventCount
    - getEventProcessingTime
- `date`: 要检索数据的日期。例子: `2023-05-03`
- `sight`: 景点名称。例子: `八公山森林公园`
- `year`：要检索数据的年份。例子：`2023`

## 运行服务器
1. 克隆仓库
2. 在根目录运行：```npm install```
3. 在VSCode编译器里按F5开始运行服务器

## 测试
在根目录运行```npm test```

## 错误代码：
- 501：数据Excel文件不在指定位置
- 502：数据Excel文件找不到需要的表格
- 503：请求内缺少日期参数
- 504：请求内缺少日期或者景点参数
- 505：不支持该请求
- 506：请求内缺少年份参数
- 500：未知错误


# English
## Endpoint: /szgc/getdata
## parameters:
- `content`:
  - Left Side API：
    - sightVisitorFlowByDay
    - gateStatus
    - sightVisitorFlowPerHour
    - guchengLoad
    - totalVisitorFlow
    - totalVisitorFlowByDay
  - Middle API：
    - currentEventStrategy
    - totalEventCount
    - allEvents
  - Right Side API：
    - getEventCountByYear
    - getEventTimeDistribution
    - getEventMonthDistribution
    - getEventCategoryCount
    - getEventSubCategoryCount
    - getEventSourceCount
    - getGridEventCount
    - getEventProcessingTime
- `date`: The date you are searching. E.g. `2023-05-03`
- `sight`: The name of the sight. E.g. `八公山森林公园`
- `year`：The year you are searching. E.g. `2023`

## Example Request：
- Left Side: 
```http://localhost:30016/getdata?content=sightVisitorFlowByDay&date=2023-05-03&sight=八公山森林公园```

- Middle: ```http://localhost:30016/getdata?content=currentEventStrategy&date=2023-05-03```

- Right Side: ```http://localhost:30016/getdata?content=getEventCategoryCount&year=2024```

## How to Run:
1. Clone the Repository (```git clone http://123.207.147.179:8888/chenjinjing/shouzhouServer.git```)
2. In the root directory, run ```npm install```
3. Using VScode IDE, press F5 to start the server.

## Testing
Run ```npm test``` in the root directory

## Error Code:
- 501: The Excel file storing the data is missing
- 502: The Excel sheet doesn't exist in the Excel file (Excel file is corrupted)
- 503: The request is missing parameter date
- 504: The request is missing parameter date and sight
- 505: Unsupported request
- 506: The request is missing parameter year
- 500: Unknown error