/**
 * mapToObj.ts
 * 该文件定义了一个函数，用于将 Map 对象转换为普通的 JavaScript 对象。
 */

/**
 * 将 Map 对象转换为普通的 JavaScript 对象。
 * @param map - 要转换的 Map 对象。
 * @returns 转换后的 JavaScript 对象。
 */
export default function mapToObj(map) {
    let Obj: { [key: string]: string } = {};
    map.forEach((value, key) => {
        Obj[key] = value;
    });
    return Obj;
}