/**
 * eventTimeDistributionStrategy.ts
 * 该文件定义了事件时间分布策略的具体实现。
 */

import {abstractDataStrategyRight} from "./abstractDataStrategyRight";
import excelSerialToJSDate from "../../../util/excelDateToJSDate";
import mapToObj from "../../../util/mapToObj";

/**
 * 事件时间分布策略类，继承自 abstractDataStrategyRight。
 */
export class eventTimeDistributionStrategy extends abstractDataStrategyRight {

    /**
     * 执行事件时间分布策略。
     * @param params - 请求参数，包含年份信息。
     * @returns 事件时间分布的对象表示。
     */
    execute(params?: any): any{
        // 检查参数是否有效
        this.paramsCheck(params);

        // 获取指定年份的事件时间分布，并转换为对象
        return mapToObj(this.getEventTimeDistribution(this.eventData, params.query.year));
    }

    /**
     * 获取指定年份的事件时间分布。
     * @param data - 从数据源提取的数据。
     * @param year - 指定年份。
     * @returns 事件时间分布的映射。
     */
    private getEventTimeDistribution(data: any, year: number) {
        const eventCount: Map<number, number> = new Map();
        for (let hour = 0; hour < 24; hour++) {
            eventCount.set(hour, 0);
        }

        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['创建时间']);
            rowDate.setHours(rowDate.getHours() - eventTimeDistributionStrategy.TIMEDIFFERENCE);
            const rowHour = rowDate.getHours()
            const rowYear = rowDate.getFullYear();
            if (rowYear == year) {
                eventCount.set(rowHour, (eventCount.get(rowHour) || 0) + 1);
            }
        });
        return eventCount;
    }
}