/**
 * eventSubCategoryCountStrategy.ts
 * 该文件定义了事件子类别计数策略的具体实现。
 */

import {abstractDataStrategyRight} from "./abstractDataStrategyRight";
import mapToObj from "../../../util/mapToObj";

/**
 * 事件子类别计数策略类，继承自 abstractDataStrategyRight。
 */
export class eventSubCategoryCountStrategy extends abstractDataStrategyRight {

    /**
     * 执行事件子类别计数策略。
     * @param params - 请求参数，包含年份信息。
     * @returns 事件子类别计数的对象表示。
     */
    execute(params?: any): any {
        // 检查参数是否有效
        this.paramsCheck(params);

        // 定义事件子类别列表
        const eventList = ['服务质量', '医疗救助', '纠纷', '环境卫生', '血族调查', '设施设备'];

        // 目标字段名称
        const target = '事件子类型';

        // 获取指定年份的事件子类别计数，并转换为对象
        return mapToObj(this.getListCount(eventList, target, this.eventData, params.query.year));
    }
}