/**
 * allEventDataStrategy.ts
 * 该文件定义了所有事件数据策略的具体实现，获取所有事件并提取相关信息。
 */

import {abstractDataStrategyMid} from "./abstractDataStrategyMid";
import excelSerialToJSDate from "../../../util/excelDateToJSDate";

/**
 * 事件数据策略类，继承自 abstractDataStrategyMid。
 */
export class allEventDataStrategy extends abstractDataStrategyMid {
    static readonly RELEVANTINFO = ['事件标题', '处置状态', '数据更新时间', '事件类型', '事件子类型', '事件来源'];

    /**
     * 执行所有事件数据策略。
     * @returns 事件的数据。
     */
    execute(): any {
        let eventData = this.extractor.getData(allEventDataStrategy.fileName, allEventDataStrategy.sheetName);
        this.removeUnusedColumns(eventData);
        return eventData;
    }

    /**
     * 移除数据中前端不使用的列
     * @param data - 从数据源提取的数据
     */
    private removeUnusedColumns(data: any) {
        data.forEach(row => {
            Object.keys(row).forEach(key => {
                if (!allEventDataStrategy.RELEVANTINFO.includes(key)) {
                    delete row[key];
                }
                if (key === '数据更新时间') {
                    row[key] = excelSerialToJSDate(row[key]);
                }
            });
        });
    }
}