/**
 * totalVisitorFlowStrategy.ts
 * 该文件定义了总游客流量策略的具体实现。
 */

import excelSerialToJSDate from "../../../util/excelDateToJSDate";
import mapToObj from "../../../util/mapToObj";
import { abstractDataStrategyLeft } from "./abstractDataStrategyLeft";

/**
 * 总游客流量策略类，继承自 abstractDataStrategyLeft。
 */
export class totalVisitorFlowStrategy extends abstractDataStrategyLeft {

    /**
     * 执行总游客流量策略。
     * @param params - 请求参数，包含日期信息。
     * @returns 每小时的全景区各类游客流量。
     */
    execute(params?: any): any {
        if (!params || !params.query || !params.query.date) {
            throw new Error("Date parameter is required.")
        }
        let sightData = this.extractor.getData(totalVisitorFlowStrategy.FILENAME, totalVisitorFlowStrategy.SHEETNAME);
        return mapToObj(this.getTotalVisitorByDay(sightData, params.query.date));
    }

    /**
     * 获取指定日期的每小时总游客流量。
     * @param data - 从数据源提取的数据。
     * @param date - 指定日期。
     * @returns 每小时的全景区各类游客流量。
     */
    private getTotalVisitorByDay(data: any, date: string) {
        const visitorCount: Map<string, number> = new Map();
        visitorCount.set('total', 0);
        visitorCount.set('老人', 0);
        visitorCount.set('儿童', 0);
        visitorCount.set('学生', 0);
        visitorCount.set('其他', 0);

        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['游玩时间']);
            let rowDateString;
            try {
                rowDateString = rowDate.toISOString().split('T')[0];
            }
            catch (e) {
                rowDateString = 'invalid time'
            }
            if (rowDateString === date) {
                visitorCount.set('total', visitorCount.get('total') + 1);
                visitorCount.set(row['订单游客类型'], (visitorCount.get(row['订单游客类型']) || 0) + 1);
            }
        });

        return visitorCount;

    }

}