/**
 * sightVisitorFlowByDayStrategy.ts
 * 该文件定义了按天计算的游客流量策略的具体实现。
 */

import { randomStatusGenerator } from "../../../util/randomStatusGenerator";
import excelSerialToJSDate from "../../../util/excelDateToJSDate";
import {abstractDataStrategyLeft} from "./abstractDataStrategyLeft";

/**
 * 按天计算的游客流量策略类，继承自 abstractDataStrategyLeft。
 */
export class sightVisitorFlowByDayStrategy extends abstractDataStrategyLeft {
    /**
     * 执行按天计算的游客流量策略。
     * @param params - 请求参数，包含日期信息。
     * @returns 每小时的游客流量。
     */
    execute(params?: any): any {
        if (!params || !params.query || !params.query.date) {
            throw new Error("Date parameter is required.")
        }
        let sightData = this.extractor.getData(sightVisitorFlowByDayStrategy.FILENAME, sightVisitorFlowByDayStrategy.SHEETNAME);
        return this.getVisitorFlowByDay(sightData, params.query.date);
    }

    /**
     * 获取指定日期所有景点的游客流量和景点状态。
     * @param data - 从数据源提取的数据。
     * @param date - 指定日期。
     * @returns 每小时的游客流量映射。
     */
    private getVisitorFlowByDay(data: any, date: string) {
        const visitorCount: { [sight: string]: { count: number, status: string } } = {};
        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['游玩时间']);
            let rowDateString;
            try {
                rowDateString = rowDate.toISOString().split('T')[0];
            }
            catch (e) {
                rowDateString = 'invalid time'
            }
            const sight = row['景点名称'];

            if (rowDateString == date) {
                if (!visitorCount[sight]) {
                    visitorCount[sight] = {count: 0, status: randomStatusGenerator.getRandomStatus()};
                }
                visitorCount[sight].count++;
            }
        });
        return visitorCount;

    }

}

