/**
 * guchengLoadStrategy.ts
 * 该文件定义了古城负载状态策略的具体实现。
 */

import { randomStatusGenerator } from "../../../util/randomStatusGenerator";
import { abstractDataStrategyLeft } from "./abstractDataStrategyLeft";

/**
 * 古城负载策略类，继承自 abstractDataStrategyLeft。
 */
export class guchengLoadStrategy extends abstractDataStrategyLeft {
    /**
     * 执行古城负载策略，生成随机的负载状态。
     * @returns 随机的负载状态。
     */
    execute(): any {
        return randomStatusGenerator.getRandomStatus();
    }
}
