/**
 * getData.ts
 * 该文件定义了用于处理请求并根据不同策略发送响应的函数。
 */

// 导入 strategyFactory，以便根据请求内容创建适当的策略。
import { strategyFactory } from "./strategies/strategyFactory";

/**
 * 处理获取数据的主要请求。
 * @param req - 请求对象，包含查询参数。
 * @param res - 响应对象，用于将结果发送回客户端。
 */
export function getData(req, res) {
    // 根据请求查询内容创建策略。
    const strategy = strategyFactory.createStrategy(req.query.content);
    // 使用请求参数执行策略并获取结果。
    let ret = strategy.execute(req);
    // 将结果发送回客户端。
    res.send(ret);
}

/**
 * 一个简单的测试函数，用于检查服务器是否正常工作。
 * @param req - 请求对象。
 * @param res - 响应对象。
 */
export function test(req, res) {
    res.send("Success!");
}