/**
 * randomStatusGenerator.ts
 * 该文件定义了 randomStatusGenerator 类，用于生成随机状态。
 */

/**
 * randomStatusGenerator 类，用于生成随机状态。
 */
export class randomStatusGenerator {
    // 定义可用状态的数组
    private static statuses: string[] = ['正常', '拥挤', '顺畅'];

    /**
     * 获取一个随机状态。
     * @returns 一个随机选择的状态字符串。
     */
    static getRandomStatus(): string {
        // 生成一个随机索引
        const randomIndex = Math.floor(Math.random() * randomStatusGenerator.statuses.length);
        // 返回对应索引的状态
        return this.statuses[randomIndex];
    }
}
