export default class paramChecker {
    static checkDateParam(params) {
        if (!params || !params.query || !params.query.date) {
            throw new Error("Date parameter is required.")
        }
    }

    static checkDateAndSightParam(params) {
        if (!params || !params.query || !params.query.date || !params.query.sight) {
            throw new Error('Date and sight parameters are required.');
        }
    }

    static checkDiscreteParam(params, paramName, ...allowedValues) {
        if (!params || !params.query || !params.query[paramName]) {
            throw new Error(`${paramName} parameter is required.`);
        }
        if (!allowedValues.includes(params.query[paramName])) {
            throw new Error(`${paramName} parameter must be one of ${allowedValues.join(", ")}.`);
        }
    }

}