import * as asyncHandler from 'express-async-handler';
import * as szgcBiz from '../../biz/getData';
import storeTypeDistributionStrategy from "../../biz/map2/strategies/right/storeTypeDistributionStrategy";

export function setMap2RightRoutes(httpServer) {
    httpServer.get('/szgc/getdata/visitorGenderProfile', asyncHandler((req, res) => szgcBiz.getData(req, res, 'visitorGenderProfile')));
    httpServer.get('/szgc/getdata/visitorAgeProfile', asyncHandler((req, res) => szgcBiz.getData(req, res, 'visitorAgeProfile')));
    httpServer.get('/szgc/getdata/visitorSourceDistribution', asyncHandler((req, res) => szgcBiz.getData(req, res, 'visitorSourceDistribution')));
    httpServer.get('/szgc/getdata/merchantBusinessStatistics', asyncHandler((req, res) => szgcBiz.getData(req, res, 'merchantBusinessStatistics')));
    httpServer.get('/szgc/getdata/businessStatus', asyncHandler((req, res) => szgcBiz.getData(req, res, 'businessStatus')));
    httpServer.get('/szgc/getdata/storeTypeDistribution', asyncHandler((req, res) => szgcBiz.getData(req, res, 'storeTypeDistribution')));
    httpServer.get('/szgc/getdata/monthlyOpeningTrend', asyncHandler((req, res) => szgcBiz.getData(req, res, 'monthlyOpeningTrend')));

}
