import {abstractCustomerProfileStrategy} from "./abstractCustomerProfileStrategy";
import paramChecker from "../../../../util/paramChecker";

export default class visitorGenderProfileStrategy extends abstractCustomerProfileStrategy {
    execute(params?: any): any {
        paramChecker.checkDiscreteParam(params, 'metric', 'ecommerce', 'ticket');
        const data = this.extractor.getData(visitorGenderProfileStrategy.FILENAME, visitorGenderProfileStrategy.SHEETNAME);
        return this.processData(data, params.query['metric']);
    }

    processData(data: any, type: string): any {
        let total = 0, maleCount = 0, femaleCount = 0;

        if (type == 'ticket') {
            data.forEach((row) => {
                total++;
                if (row['性别'] === '男') {
                    maleCount++;
                }
                else {
                    femaleCount++;
                }
            });
        } else if (type == 'ecommerce') {
            total = 3429;
            maleCount = Math.floor(Math.random() * 1700) + 100;
            femaleCount = total - maleCount;
        }

        const result = type === 'ticket' ?{
            总游客数: total,
            男性游客: maleCount,
            女性游客: femaleCount
        } : {
            总会员数: total,
            男性会员: maleCount,
            女性会员: femaleCount
        }
        return Object.entries(result).map(([key, value]) => ({key, value}));

    }

}