import paramChecker from "../../../../util/paramChecker";
import {abstractCustomerProfileStrategy} from "./abstractCustomerProfileStrategy";

export default class visitorAgeProfileStrategy extends abstractCustomerProfileStrategy{
    execute(params?: any): any {
        paramChecker.checkDiscreteParam(params, 'metric', 'ticket', 'ecommerce');
        return this.processData(params.query['metric']);
    }

    processData(type: string): any {
        const total = type === 'ticket' ? 1000 : 3429;

        // Generate random values for each age group ensuring they sum up to total
        const children = Math.floor(Math.random() * (total * 0.2));
        const teenagers = Math.floor(Math.random() * (total * 0.2));
        const youngAdults = Math.floor(Math.random() * (total * 0.5));
        const adults = total - (children + teenagers + youngAdults);

        const ageGroups = [
            {
                key: '儿童',
                value: {
                    count: children,
                    percent: ((children / total) * 100).toFixed(2) + '%'
                }
            },
            {
                key: '少年',
                value: {
                    count: teenagers,
                    percent: ((teenagers / total) * 100).toFixed(2) + '%'
                }
            },
            {
                key: '青年',
                value: {
                    count: youngAdults,
                    percent: ((youngAdults / total) * 100).toFixed(2) + '%'
                }
            },
            {
                key: '老年',
                value: {
                    count: adults,
                    percent: ((adults / total) * 100).toFixed(2) + '%'
                }
            }
        ];

        return ageGroups;
    }
}
