export default class storeTypeDistributionStrategy {
    execute(): any {
        return this.generateStoreTypeData();
    }

    private generateStoreTypeData(): any {
        const totalStores = 1000; // Total number of stores to be randomly distributed

        const storeTypes = [
            '文化创意',
            '特色餐饮',
            '茶馆饮品',
            '民宿客栈',
            '特色工艺品',
            '摄影照相',
            '体验式商铺'
        ];

        const randomValues = Array.from({ length: storeTypes.length - 1 }, () => Math.floor(Math.random() * totalStores * 0.3));
        const remainingValue = totalStores - randomValues.reduce((a, b) => a + b, 0);
        randomValues.push(remainingValue);

        const result = randomValues.map((value, index) => ({
            key: storeTypes[index],
            value: value
        }));

        result.sort((a, b) => b.value - a.value);

        return result;
    }
}
