export default class monthlyOpeningTrendStrategy {
    execute(): any {
        return this.generateMonthlyOpeningTrendData();
    }

    private generateMonthlyOpeningTrendData(): any {
        const currentDate = new Date();
        const trendData = [];

        for (let i = 11; i >= 0; i--) {
            const date = new Date(currentDate.getFullYear(), currentDate.getMonth() - i, 1);
            const month = `${date.getFullYear().toString().slice(2)}/${(date.getMonth() + 1).toString().padStart(2, '0')}`;
            const count = Math.floor(Math.random() * 300) + 100;
            trendData.push({
                key: month,
                value: count
            });
        }

        return trendData;
    }
}
