import {abstractMerchantProfileStrategy} from "./abstractMerchantProfileStrategy";

export default class merchantBusinessStatisticsStrategy extends abstractMerchantProfileStrategy {
    execute(): any {
        return this.processData();
    }

    processData(): any {
        const totalBusinesses = Math.floor(Math.random() * 2000) + 1000;
        const totalShops = Math.floor(Math.random() * 2500) + 1500;
        const businessActivityRate = Math.floor(Math.random() * 50) + 50; // Random percentage between 50% and 100%

        const result = [
            {
                key: '营业商家数',
                value: totalBusinesses
            },
            {
                key: '营业店铺数',
                value: totalShops
            },
            {
                key: '商家动销率',
                value: businessActivityRate
            }
        ];

        return result;
    }
}
