import {dataStrategy} from "../../../dataStrategy";

export default class businessStatusStrategy implements dataStrategy{
    execute(): any {
        return this.processData();
    }

    processData(): any {
        const totalStores = Math.floor(Math.random() * 2000) + 1000;
        const openStores = Math.floor(Math.random() * totalStores * 0.8) + 1;
        const closedStores = totalStores - openStores;

        const result = [
            { key: '门店数', value: totalStores },
            { key: '开店数', value: openStores },
            { key: '关店数', value: closedStores }
        ];

        result.sort((a, b) => b.value - a.value);

        return result;
    }
}
