import {dataStrategy} from "../../../dataStrategy";
import {DataExtractor} from "../../../../util/dataExtractor";

export abstract class abstractMerchantProfileStrategy implements dataStrategy {
    // 实例化数据提取器
    extractor = DataExtractor.getInstance();
    static readonly FILENAME = '票务系统.xlsx';
    static readonly SHEETNAME = '票务系统-游客门票表';

    /**
     * 执行策略的方法，具体实现由子类提供。
     * @param params - 可选参数。
     */
    abstract execute(params?: any): any;
    abstract processData(...param): any;

}