import paramChecker from "../../../../util/paramChecker";
import excelSerialToJSDate from "../../../../util/excelDateToJSDate";
import {abstractDataStrategyMid} from "./abstractDataStrategyMid";

export default class leftSideMapDataStrategy extends abstractDataStrategyMid{

    execute(params?: any): any {
        paramChecker.checkDiscreteParam(params, 'year', 'thisyear', 'lastyear');
        const data = this.extractor.getData(leftSideMapDataStrategy.FILENAME, leftSideMapDataStrategy.SHEETNAME);
        return this.processData(data, params.query['year']);
    }

    processData(data: any, year: string): any {
        const currentYear = new Date().getFullYear();
        const targetYear = year === 'thisyear' ? currentYear : currentYear - 1;

        const filteredData = data.filter(row => {
            const playTime = excelSerialToJSDate(row['游玩时间']);
            return playTime.getFullYear() === targetYear;
        });

        const totalVisitors = filteredData.length;
        const totalTicketRevenue = filteredData.reduce((sum, row) => sum + row['订单金额'], 0);
        const totalEcommerceRevenue = Math.floor(Math.random() * 1000000) + 100000; // Random e-commerce revenue
        const visitorIncreaseRate = (Math.random() * 5 - 2.5).toFixed(2); // Random rate between -2.5% and +2.5%
        const ticketRevenueIncreaseRate = (Math.random() * 5 - 2.5).toFixed(2); // Random rate between -2.5% and +2.5%
        const ecommerceRevenueIncreaseRate = (Math.random() * 5 - 2.5).toFixed(2); // Random rate between -2.5% and +2.5%

        const randomNonZeroValue = () => Math.floor(Math.random() * 10000) + 100;

        const result = {
            totalReception: {
                total: totalVisitors === 0 ? randomNonZeroValue() : totalVisitors,
                IncreaseRate: `${visitorIncreaseRate}%`,
                cumulative: `${(Math.random() * 7000000 + 100000).toFixed(0)}人次`
            },
            ticketRevenue: {
                total: totalTicketRevenue === 0 ? (randomNonZeroValue() / 100).toFixed(2) : (totalTicketRevenue / 10000).toFixed(2),
                IncreaseRate: `${ticketRevenueIncreaseRate}%`,
                cumulative: `${(Math.random() * 7000000 + 100000).toFixed(2)}万元`
            },
            ecommerceRevenue: {
                total: totalEcommerceRevenue === 0 ? (randomNonZeroValue() / 100).toFixed(2) : (totalEcommerceRevenue / 10000).toFixed(2),
                IncreaseRate: `${ecommerceRevenueIncreaseRate}%`,
                cumulative: `${(Math.random() * 7000000 + 100000).toFixed(2)}万元`
            }
        };

        return result;
    }
}
