import {abstractDataStrategyLeft} from "./abstractDataStrategyLeft";

export default class sightVisitorRankStrategy extends abstractDataStrategyLeft {
    static readonly FILENAME = '票务系统.xlsx';
    static readonly SHEETNAME = '票务系统-订单主表';

    execute(params?: any): any {
        const data = this.extractor.getData(sightVisitorRankStrategy.FILENAME, sightVisitorRankStrategy.SHEETNAME);
        return this.processData(data);
    }

    processData(data: any): any {
        const sightCounts: { [key: string]: number } = {};

        data.forEach(row => {
            const sightName = row['景点名称'];
            if (!sightCounts[sightName]) {
                sightCounts[sightName] = 0;
            }
            sightCounts[sightName] += 1;
        });

        const sortedSights = Object.entries(sightCounts)
            .sort(([, a], [, b]) => b - a)
            .map(([key, value]) => ({ key, value: value }));

        return sortedSights;
    }
}
