import {abstractDataStrategyLeft} from "./abstractDataStrategyLeft";
import paramChecker from "../../../../util/paramChecker";

export default class ecommerceRankingStrategy extends abstractDataStrategyLeft {
    execute(params?: any): any {
        paramChecker.checkDiscreteParam(params, 'metric', 'revenue', 'customerPrice');
        return this.processData(params.query['metric']);
    }

    processData(metric: string): any {
        const generateRandomValues = (count: number) => {
            return Array.from({ length: count }, () => Math.floor(Math.random() * 5000) + 1000);
        };

        const shopData = generateRandomValues(4);
        const productData = generateRandomValues(4);

        shopData.sort((a, b) => b - a);
        productData.sort((a, b) => b - a);

        const formatData = (data: number[], prefix: string) => {
            return data.map((value, index) => ({
                name: `${prefix}${index + 1}`,
                value: `${value}元`
            }));
        };

        const result = {
            shops: formatData(shopData, '商家'),
            products: formatData(productData, '商品')
        };

        return result;
    }
}
