/**
 * getData.ts
 * 该文件定义了用于处理请求并根据不同策略发送响应的函数。
 */

// 导入 strategyFactory，以便根据请求内容创建适当的策略。
import { strategyFactory } from "./strategyFactory";

/**
 * Handles the main data retrieval request.
 * @param req - The request object containing query parameters.
 * @param res - The response object used to send results back to the client.
 * @param strategyType - The type of strategy to be used.
 */
export function getData(req, res, strategyType: string) {
    const strategy = strategyFactory.createStrategy(strategyType);
    let ret = strategy.execute(req);
    res.setHeader('Content-Type', 'application/json; charset=utf-8');
    res.send(ret);
}

/**
 * 一个简单的测试函数，用于检查服务器是否正常工作。
 * @param req - 请求对象。
 * @param res - 响应对象。
 */
export function test(req, res) {
    res.send("Success!");
}