import {eventCategoryCountStrategy} from "../biz/map1/strategies/right/eventCategoryCountStrategy";
import {testStrategy, testYearError} from "./utils";
import {eventMonthDistributionStrategy} from "../biz/map1/strategies/right/eventMonthDistributionStrategy";
import {eventProcessingTimeStrategy} from "../biz/map1/strategies/right/eventProcessingTimeStrategy";
import {eventSrcStrategy} from "../biz/map1/strategies/right/eventSrcStrategy";
import {eventSubCategoryCountStrategy} from "../biz/map1/strategies/right/eventSubCategoryCountStrategy";
import {eventTimeDistributionStrategy} from "../biz/map1/strategies/right/eventTimeDistributionStrategy";
import {getEventCountByYearStrategy} from "../biz/map1/strategies/right/getEventCountByYearStrategy";
import {gridEventCountStrategy} from "../biz/map1/strategies/right/gridEventCountStrategy";

const mockParams = {
    query: {
        year: '2023'
    }
};

describe('eventCategoryCount test', function () {
    const strategy = new eventCategoryCountStrategy();
    it('should throw an error if year parameter is missing', ()=> {
        testYearError(strategy);
    })
    it('should get correct value', ()=> {
        const truthValue = {
            '咨询': 37,
            '建议': 25,
            '投诉': 29,
            '指挥调度': 22,
            '求助': 20,
            '预警系统':20
        }
        testStrategy(strategy, mockParams, truthValue)
    });
});

describe('eventMonthDistribution test', function () {
    const strategy = new eventMonthDistributionStrategy();
    it('should throw an error if year parameter is missing', ()=> {
        testYearError(strategy);
    });
    it('should get correct results', ()=> {
        const truthValue = {
            1: 20,
            2: 15,
            3: 12,
            4: 13,
            5: 7,
            6: 14,
            7: 13,
            8: 11,
            9: 10,
            10: 11,
            11: 12,
            12: 15
        }
        testStrategy(strategy, mockParams, truthValue);
    });
});

describe('eventProcessingTime test', function () {
    const strategy = new eventProcessingTimeStrategy();
    it('should throw an error if year parameter is missing', ()=> {
        testYearError(strategy);
    });

    it('should get correct results', ()=> {
        const res = strategy.execute(mockParams);
        expect(res.调度时长).toBeLessThan(1.7);
        expect(res.调度时长).toBeGreaterThan(0.5);
        expect(res.处置等待).toBeCloseTo(5, 0.01);
        expect(res.处置时长).toBeCloseTo(30, 0.01);
        expect(res.办结时长).toBeCloseTo(52.75, 0.1)
    })
});

describe('eventSrc test', function () {
    const strategy = new eventSrcStrategy();
    it('should throw an error if year parameter is missing', ()=> {
        testYearError(strategy);
    });

    it('should get correct results', ()=> {
        const truthValue = {
            '12301热线': 25,
            '12345热线': 27,
            '指挥调度': 24,
            '景管通': 27,
            '电话热线': 22,
            '舆情平台': 28
        };
        testStrategy(strategy, mockParams, truthValue);
    })
});

describe('eventSubCategoryCount test', function () {
    const strategy = new eventSubCategoryCountStrategy();
    it('should throw an error if year parameter is missing', ()=> {
        testYearError(strategy);
    });
    it('should get correct results', ()=>{
        const truthValue = {
            '医疗救助': 25,
            '服务质量': 29,
            '环境卫生': 25,
            '纠纷': 26,
            '血族调查': 20,
            '设施设备': 28
        }
        testStrategy(strategy, mockParams, truthValue);
    })
});

describe('eventTimeDistribution test', function () {
    const strategy = new eventTimeDistributionStrategy();
    it('should throw an error if year parameter is missing', ()=> {
        testYearError(strategy);
    });
    it('should get correct result', ()=> {
        const truthValue = {
            0: 3,
            1: 9,
            2: 6,
            3: 6,
            4: 3,
            5: 5,
            6: 6,
            7: 4,
            8: 11,
            9: 7,
            10: 8,
            11: 5,
            12: 6,
            13: 3,
            14: 7,
            15: 5,
            16: 6,
            17: 10,
            18: 9,
            19: 7,
            20: 5,
            21: 6,
            22: 5,
            23: 11
        }
        testStrategy(strategy, mockParams, truthValue);
    })
});

describe('getEventCountByYear test', function () {
    const strategy = new getEventCountByYearStrategy();
    it('should throw an error if year parameter is missing', ()=> {
        testYearError(strategy);
    });
    it('should get correct result', ()=> {
        const truthValue = {
            '事件总数': 153,
            '历史遗留': 0,
            '办结率': 29 / 153
        }
        testStrategy(strategy, mockParams, truthValue);
    });
});

describe('gridEventCount test', function () {
    const strategy = new gridEventCountStrategy();
    it('should throw an error if year parameter is missing', ()=> {
        testYearError(strategy);
    });
    it('should give correct result', ()=> {
        const truthValue = {
            '八公山景区': 65,
            '寿县古城': 38,
            '寿州全域': 50
        }
        testStrategy(strategy, mockParams, truthValue);
    })
});