/**
 * Checks if any value in the object is zero and replaces it with a random value.
 * @param obj - The object to check.
 * @param min - The minimum value for the random number.
 * @param max - The maximum value for the random number.
 */
function replaceZeroValuesWithRandom(obj: { [key: string]: number }, min: number, max: number) {
    for (let key in obj) {
        if (obj[key] === 0) {
            obj[key] = Math.floor(Math.random() * (max - min + 1)) + min;
        }
    }
}
