/**
 * getRandomNumber.ts
 * 该文件定义了一个函数，用于生成指定范围内的随机数，并保留指定的小数位数。
 */

/**
 * 生成指定范围内的随机数，并保留指定的小数位数。
 * @param min - 最小值。
 * @param max - 最大值。
 * @param decimalPlaces - 保留的小数位数。
 * @returns 生成的随机数。
 */
export default function getRandomNumber(min: number, max: number, decimalPlaces: number): number {
    // 生成 min 到 max 范围内的随机数
    const randomNum = Math.random() * (max - min) + min;

    // 将随机数四舍五入到指定的小数位数
    return Math.round(randomNum * Math.pow(10, decimalPlaces)) / Math.pow(10, decimalPlaces);
}