/**
 * eventSrcStrategy.ts
 * 该文件定义了事件来源统计策略的具体实现。
 */

import {abstractDataStrategyRight} from "./abstractDataStrategyRight";
import mapToObj from "../../../util/mapToObj";

/**
 * 事件来源策略类，继承自 abstractDataStrategyRight。
 */
export class eventSrcStrategy extends abstractDataStrategyRight {

    /**
     * 执行事件来源统计策略。
     * @param params - 请求参数，包含年份信息。
     * @returns 事件来源统计的对象表示。
     */
    execute(params?: any): any {
        // 检查参数是否有效
        this.paramsCheck(params);

        // 定义事件来源列表
        const sourceList = ['景管通', '12301热线', '舆情平台', '电话热线', '指挥调度', '12345热线']

        // 目标字段名称
        const target = '事件来源';

        // 获取指定年份的事件来源统计，并转换为对象
        return mapToObj(this.getListCount(sourceList, target, this.eventData, params.query.year), "source", "count");
    }
}