const fs = require('fs');
const xlsx = require('node-xlsx');
const path = require('path');

//获取单个目录下的单个excel文件数据 只能有一个文件
export function getExcelDataByPath (dir) {
    console.log(path.join(__dirname,dir))
    let files = fs.readdirSync( path.join(__dirname,dir));

    for (let i = 0; i < files.length; i++) {
        if (files[i].indexOf('~') == 0 || files[i].indexOf('.') == 0) continue;
        const workSheetsFromFile = xlsx.parse(dir+'/'+files[i]);
        let sheetMap = {};
        let sheetList = [];
        for (let i = 0; i < workSheetsFromFile.length; i++) {
            let sheetInfo = workSheetsFromFile[i];
            sheetMap[sheetInfo.name] = sheetInfo.data;
            sheetList.push(sheetInfo.data)
        }
    
        return {sheetMap, sheetList}
    }   
}

export function updateExcel(data, fileName) {
    try{
        fs.writeFileSync('output.xlsx', xlsx.build(data), "binary");
        console.log(`写入 ${fileName} 成功`);
    }catch(err) {
        console.log(err);
    }
    
}

//获取单个excel文件的数据
export function getExcelDataByFile(filePath) {
    const workSheetsFromFile = xlsx.parse(filePath);
    let sheetMap = {};
    let sheetList = [];
    for (let i = 0; i < workSheetsFromFile.length; i++) {
        let sheetInfo = workSheetsFromFile[i];
        sheetMap[sheetInfo.name] = sheetInfo.data;
        sheetList.push(sheetInfo);
    }

    return {sheetMap, sheetList}  
}

export function arrayToObject(dataArr, keyNameArr) {
    let obj = {};
    for (let i = 0; i < dataArr.length; i++) {
        obj[keyNameArr[i]] = dataArr[i];
    }

    return obj;
}