
    import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace, getStringMoreData }from "../util/tools";
    import { get综合能源 } from "../data/analysisExcelData";
    
    export function getData(req, res) {
        let ret:any = {};

        let excelData:any = get综合能源();
    
        let 潜力用户概览DataAndUnit = objKeyReplace(excelData.潜力用户概览);
        ret["api1"] =  getKeyValue("潜力用户概览", 潜力用户概览DataAndUnit.dataMap, 潜力用户概览DataAndUnit.unitMap, false, false );
    
        let 综合能源智能匹配DataAndUnit = objKeyReplace(excelData.综合能源智能匹配);
        ret["api2"] =  getKeyValue("综合能源智能匹配", 综合能源智能匹配DataAndUnit.dataMap, 综合能源智能匹配DataAndUnit.unitMap, false, false );
    
        let 项目覆盖范围DataAndUnit = objKeyReplace(excelData.项目覆盖范围);
        ret["api3"] =  getKeyValue("项目覆盖范围", 项目覆盖范围DataAndUnit.dataMap, 项目覆盖范围DataAndUnit.unitMap, false, false );
    
        let 系统效果DataAndUnit = objKeyReplace(excelData.系统效果);
        ret["api4"] =  getKeyValue("系统效果", 系统效果DataAndUnit.dataMap, 系统效果DataAndUnit.unitMap, false, false );
    
        ret["api5"] = getChartData("储能用户月分析（青浦区）", excelData.储能用户月分析_青浦区_, false, false );
    
        ret["api6"] = getChartData("储能用户季度分析（青浦区）", excelData.储能用户季度分析_青浦区_, false, false );
    
        ret["api7"] = getChartData("储能用户年分析（青浦区）", excelData.储能用户年分析_青浦区_, false, false );
    
        ret["api8"] = getListData("服务方案热度排名",excelData.服务方案热度排名,["排名","方案名称","热度"],{"排名":"rank","方案名称":"name","热度":"info"});
    
        ret["api9"] = getListData("服务方案收益排名",excelData.服务方案收益排名,["排名","方案名称","收益"],{"排名":"rank","方案名称":"name","收益":"info"});
    
        ret["api10"] = getSingleYAndMoreData("用户类型（青浦区）", excelData.用户类型_青浦区_, false, '户');
    
        ret["api11"] = getSingleYAndMoreData("行业分类用户（青浦区）", excelData.行业分类用户_青浦区_, false, '户');
    
        ret["api12"] = getStringMoreData("综合能源智能匹配文本", excelData.综合能源智能匹配文本);

        ret["api13"] = getStringMoreData("青浦区综合能效服务项目案例", excelData.青浦区综合能效服务项目案例);

        ret["api14"] = getStringMoreData("系统配置", excelData.系统配置);

        res.send(ret);
    }
