
    import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace, analysisAddOrRMData, getKeyStringValue }from "../util/tools";
    import { get智慧电眼_住宅空置率 } from "../data/analysisExcelData";
    
    export function getData(req, res) {
        let ret:any = {};

        let excelData:any = get智慧电眼_住宅空置率();
    
        let 空置户特化数据 = {};
        for (let key in excelData.空置户数据) {
            空置户特化数据[key] = analysisAddOrRMData(excelData.空置户数据[key]);
        }
        let 空置户数据DataAndUnit = objKeyReplace(空置户特化数据);
        ret["api1"] =  getKeyValue("空置户数据", 空置户数据DataAndUnit.dataMap, 空置户数据DataAndUnit.unitMap, false, false );
    

        let 住房空置率特化基础数据 = {};
        for (let key in excelData.住房空置率数据) {
            住房空置率特化基础数据[key] = analysisAddOrRMData(excelData.住房空置率数据[key]);
        }
        let 住房空置率数据DataAndUnit = objKeyReplace(住房空置率特化基础数据);
        ret["api2"] =  getKeyValue("住房空置率数据", 住房空置率数据DataAndUnit.dataMap, 住房空置率数据DataAndUnit.unitMap, false, false );
    

        let 空置用户电量特化基础数据 = {};
        for (let key in excelData.空置用户电量数据) {
            空置用户电量特化基础数据[key] = analysisAddOrRMData(excelData.空置用户电量数据[key]);
        }
        let 空置用户电量数据DataAndUnit = objKeyReplace(空置用户电量特化基础数据 );
        ret["api3"] =  getKeyValue("空置用户电量数据", 空置用户电量数据DataAndUnit.dataMap, 空置用户电量数据DataAndUnit.unitMap, false, false );
    
        ret["api4"] = getChartData("青浦区住房空置率趋势", excelData.青浦区住房空置率趋势, 'inData', false );
    
        ret["api5"] = getMoreYChartData("重点区域住房空置率", excelData.重点区域住房空置率, false, {"用户数":"户","空置率":"%"})
    
        ret["api6"] = getMoreYChartData("典型小区住房空置率", excelData.典型小区住房空置率, false, {"用户数":"户","空置率":"%"})
    
        ret["api7"] = getMoreYChartData("重点区域空置户趋势", excelData.重点区域空置户趋势, false, {"用户数":"户","空置率":"%"})
    
        ret["api8"] = getMoreYChartData("典型小区空置户趋势", excelData.典型小区空置户趋势, false, {"用户数":"户","空置率":"%"})
    
        ret["apiarea"] = getKeyStringValue("范围数据", excelData.范围数据);
        res.send(ret);
    }
    
