
    import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace, getDecimalForN, getKeyStringValue }from "../util/tools";
    import { get智慧电眼_商圈经济活力 } from "../data/analysisExcelData";
    
    export function getData(req, res) {
        let ret:any = {};

        let excelData:any = get智慧电眼_商圈经济活力();
    
        let 基础数据DataAndUnit = objKeyReplace(excelData.基础数据);
        ret["api1"] =  getKeyValue("基础数据", 基础数据DataAndUnit.dataMap, 基础数据DataAndUnit.unitMap, false, false );
    
        ret["api2"] = getSingleYAndMoreData("进博会核心区消费类型分析", checkNumber(excelData.进博会核心区消费类型分析), false, false);
        ret["api3"] = getSingleYAndMoreData("进博会核心区节假日活力指数分析", checkNumber(excelData.进博会核心区节假日活力指数分析), false, false);
        
        ret["api4"] = getMoreYChartData("青浦重点商圈经济活力指数", excelData.青浦重点商圈经济活力指数, false, false);
        ret["api5"] = getSingleYAndMoreData("青浦重点商圈经济活力变化趋势", excelData.青浦重点商圈经济活力变化趋势, false, false);

        ret["api6"] = getSingleYAndMoreData("赵巷区消费类型分析", checkNumber(excelData.赵巷区消费类型分析), false, false);
        ret["api7"] = getSingleYAndMoreData("赵巷区节假日活力指数分析", checkNumber(excelData.赵巷区节假日活力指数分析), false, false);
        ret["api8"] = getSingleYAndMoreData("青浦新城消费类型分析", checkNumber(excelData.青浦新城消费类型分析), false, false);
        ret["api9"] = getSingleYAndMoreData("青浦新城节假日活力指数分析", checkNumber(excelData.青浦新城节假日活力指数分析), false, false);
        ret["api10"] = getSingleYAndMoreData("朱家角古镇消费类型分析", checkNumber(excelData.朱家角古镇消费类型分析), false, false);
        ret["api11"] = getSingleYAndMoreData("朱家角古镇节假日活力指数分析", checkNumber(excelData.朱家角古镇节假日活力指数分析), false, false);

        ret["apiarea"] = getKeyStringValue("范围数据", excelData.范围数据);

        res.send(ret);
    }
     

    //特化  小数保留两位
    function checkNumber(data) {
        let result = {};

        for (let key in data) {
            result[key] = {};
            let info = data[key];
            for (let subKey in info) {
                let value = info[subKey] ? getDecimalForN(parseFloat(info[subKey]), 2) : 0;
                result[key][subKey] = value;
            }
        }

        return result;
    }