let fs = require('fs');
const xlsx = require('node-xlsx');
const path = require('path');
//excel的名字
//const excelName = "其他数据模板.xlsx";
// const excelAnalysisName = "其他数据规则.xlsx";
const excelName = "绿色电力数据模板.xlsx";
const excelAnalysisName = "绿色电力解析规则.xlsx";


let typeEnum = {
    "柱状数据":1,
    "列表数据":1,
    "单轴多柱状数据":1,
    "双轴多柱状数据":1,
}

function changeDataName(str) {
    let result = str.replace(/[()""“”（）]/, "_");
    for (let i =0; i < 10; i++) {
        result = result.replace(/[()""“”（）]/, "_");
    }
    return result;
}

let createBizAndDataConfigMap = {
    // "page1": {
    //     sheetName:"智慧电眼_电力用户数", 
    //     apiList:[
    //         { type:"键值数据", dataName:"基础数据", title:"基础数据", unit:"inData", total:true, percent:false},
    //         { type:"双轴多柱状数据", dataName:"用电趋势", title:"用电趋势", unit:{"用户数":"家", "空置率":"%"}, total:true, percent:false},
    //         { type:"柱状数据", dataName:"用电排序趋势", title:"用电排序趋势", unit:"户", total:true, percent:false},
    //         { type:"柱状数据", dataName:"企业生产指数", title:"企业生产指数", unit:"户", total:true, percent:false}
    //     ]
    // }
};

//配置解析excel
function analysisConfigExcel() {
    const workSheetsFromFile = xlsx.parse(`../res/${excelAnalysisName}`);
    let sheetMap = {};
    let sheetList = [];

    for (let i = 0; i < workSheetsFromFile.length; i++) {
        let sheetInfo = workSheetsFromFile[i];
        sheetMap[sheetInfo.name] = sheetInfo.data;
        sheetList.push(sheetInfo);
    }

    return sheetMap
}

function createConfig() {
    let excelData = analysisConfigExcel();
    for (let configSheetName in excelData) {
        let data = excelData[configSheetName];
        
        for (let y = 1; y < data.length; y++) {
            let valueList = data[y];
            let pageName = valueList[0];
            let sheetName = valueList[1];
            let type = valueList[2];
            let dataName = changeDataName(valueList[3]);
            let title = valueList[4];
            let unit = valueList[5];
            let total = valueList[6];
            let percent = valueList[7];
            let titleList = valueList[8] ? JSON.parse(valueList[8]) : "";
            let keyValueObj = valueList[9] ? JSON.parse(valueList[9]) : "" ;
            if (!createBizAndDataConfigMap[pageName] ) createBizAndDataConfigMap[pageName]  = {sheetName, apiList:[]};
            createBizAndDataConfigMap[pageName].apiList.push({ type ,dataName ,title ,unit ,total ,percent, titleList, keyValueObj });

        }
    }
}
createConfig();

//创建data层
function createData() {
    let str = `
    import * as path from "path";
    import * as fs from "fs";
    import { BizError } from "../util/bizError";
    import { limitEnteNameString, changeDataName } from "../util/tools";
    import { getExcelDataBySheetName, analysisExcelDataOfObject, analysisExcelDataOfMoreObject, analysisExcelDataOfList } from "../util/analysisExcel";`;

    for (let pangeName in createBizAndDataConfigMap) {
        let { sheetName } = createBizAndDataConfigMap[pangeName];

        let ofMoreObjList = [];
        let ofObjList = [];
        let listDataAnalysisInfo = {};
        createBizAndDataConfigMap[pangeName].apiList.forEach( info => {
            if (info.type == "双轴多柱状数据" || info.type == "单轴多柱状数据") ofMoreObjList.push(info.dataName);
            else if (info.type == "列表数据") listDataAnalysisInfo[info.dataName] = {titleList:info.titleList, keyValueObj:info.keyValueObj};
            else ofObjList.push(info.dataName);
        });
    

    str += `
    export function get${sheetName}() {;
        let bolckDataList = getExcelDataBySheetName('${excelName}', '${sheetName}');
        let result = {};
        let ofMoreObjList = ${JSON.stringify(ofMoreObjList)};
        let ofObjList = ${JSON.stringify(ofObjList)};
        let listDataAnalysisInfo = ${JSON.stringify(listDataAnalysisInfo)};
        for (let i = 0; i < bolckDataList.length; i++) {
            let {blockData, blockTitle} = bolckDataList[i];
           
            let changeName = changeDataName(blockTitle);
            if (ofMoreObjList.indexOf(changeName) > -1)  result[changeName] = analysisExcelDataOfMoreObject(blockData, false);
            if (ofObjList.indexOf(changeName) > -1) result[changeName] = analysisExcelDataOfObject(blockData, true, false);
            if (listDataAnalysisInfo[changeName]) result[changeName] = analysisExcelDataOfList(blockData, listDataAnalysisInfo[blockTitle].keyValueObj, false);
        }
        
        return result;
    }`;
    }

    let path = `./data/analysisExcelData.ts`;
    fs.access(path, (err) => {
        if (!err) {
            console.error(path, "文件已存在");
            return;
        }
        
        fs.writeFileSync(path,  str);
        console.log(path, "创建文件成功")
    });
}

//创建biz层
function createBiz(){
    for (let pageName in createBizAndDataConfigMap) {
        let { apiList, sheetName } = createBizAndDataConfigMap[pageName];

        let thisBizData = getBizStr(apiList, sheetName);

        let path = `./biz/${pageName}.ts`;
        fs.access(path, (err) => {
            if (!err) {
                console.error(path, "文件已存在");
                return;
            }
            
            fs.writeFileSync(path,  thisBizData);
            console.log(path, "创建文件成功")
        });

    }
}


function getBizStr(apiList, sheetName) {
    let str = `
    import { getChartData, getKeyValue, getListData, getSingleYAndMoreData, getMoreYChartData, objKeyReplace }from "../util/tools";
    import { get${sheetName} } from "../data/analysisExcelData";
    `;
    str += `
    export function getData(req, res) {
        let ret:any = {};

        let excelData:any = get${sheetName}();
    `;
    apiList.forEach((info, index) => {
        let  {dataName, unit, total, percent, type, titleList, keyValueObj} = info;
        const apiName = `api${index+1}`;

        let subStr;
        let chartUnit;

        switch(type) {
            case "键值数据": 
            subStr = `
        let ${dataName}DataAndUnit = objKeyReplace(excelData.${dataName});`;
            if (unit == 'inData') {
                subStr += `
        ret["${apiName}"] =  getKeyValue("${dataName}", ${dataName}DataAndUnit.dataMap, ${dataName}DataAndUnit.unitMap, ${total}, ${percent} );`;
            } else {
                subStr += `
        ret["${apiName}"] =  getKeyValue("${dataName}", ${dataName}DataAndUnit.dataMap, ${typeof unit == 'boolean' ? unit : `'${unit}'`}, ${total}, ${percent} );`;
            }
            break;
            case "柱状数据": 
                chartUnit = typeof unit == 'boolean' ? unit : `'${unit}'`;
                subStr = `
        ret["${apiName}"] = getChartData("${dataName}", excelData.${dataName}, ${chartUnit}, ${percent} );`; 
            break;
            case "列表数据": 
                subStr = `
        ret["${apiName}"] = getListData("${dataName}",excelData.${dataName},${JSON.stringify(titleList)},${JSON.stringify(keyValueObj)});`; 
            break;
            case "单轴多柱状数据": 
            chartUnit = typeof unit == 'boolean' ? unit : `'${unit}'`;
            subStr = `
        ret["${apiName}"] = getSingleYAndMoreData("${dataName}", excelData.${dataName}, ${percent}, ${chartUnit});`; 
            break; 
            case "双轴多柱状数据": 
            subStr = `
        ret["${apiName}"] = getMoreYChartData("${dataName}", excelData.${dataName}, ${percent}, ${unit})`; 
            break;
        };

        str+=
    `${subStr}
    `

    });
   
    
    str += `
        res.send(ret);
    }
    `
    return str;
}

//创建Router层
function createRouter() {
    let importName =``;
    let routergetName=``;
    let routerpostName=``;

    for (let pageName in createBizAndDataConfigMap) {
        importName+=`
import * as ${pageName}Biz from '../biz/${pageName}';`;
        routergetName+=`
    httpServer.get('/${pageName}', asyncHandler(${pageName}Biz.getData));`;
        routerpostName+=`
    httpServer.post('/${pageName}', asyncHandler(${pageName}Biz.getData));`;
    }

    let str=`
import * as asyncHandler from 'express-async-handler'
${importName}

export function setRouter(httpServer){
        ${routergetName}
        ${routerpostName}
}`;

    let path = `./routers/router.ts`;
    fs.access(path, (err) => {
        if (!err) {
            console.error(path, "文件已存在");
            return;
        }
        
        fs.writeFileSync(path, str);
        console.log(path, "创建router文件成功")
    });
}

createData();
createBiz();
createRouter();




