import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

export async function getZzkzl() {
    let interfaceName = "住宅空置率";
    let {vacantHouseholdData, housingVacancyRateData, IdleUserPowerData, qingPuDistrictHousingVacancyRateTrend, housingVacancyRateInKeyAreas,
        typicalResidentialVacancyRate, vacantHouseholdsInKeyAreas, typicalResidentialVacancyTrends, rangeData} = await getInterfaceByInterfaceName(interfaceName);
    
    // ----------------test---------------------
    // let vacantHouseholdData:any = {"numberOfVacantHouseholds":31924,"yoy":-2.77,"chainRatio":0.13,"statCycle":"202206"};
    // let housingVacancyRateData:any = {"housingVacancyRate":7.76,"yoy":-6.27,"chainRatio":-0.11};
    // let IdleUserPowerData:any = {"averagePowerConsumptionOfVacantUsers":0.47,"yoy":4.44,"chainRatio":58.33};
    // let qingPuDistrictHousingVacancyRateTrend = [{"month":"202109","quantity":7.73},{"month":"202110","quantity":7.52},{"month":"202111","quantity":7.43},{"month":"202112","quantity":7.10},{"month":"202201","quantity":7.28},{"month":"202202","quantity":7.29},{"month":"202203","quantity":7.20},{"month":"202204","quantity":7.32},{"month":"202205","quantity":7.77},{"month":"202206","quantity":7.76}];
    // let housingVacancyRateInKeyAreas = [{"keyAreaName":"青浦新城","userNum":7025,"vacancyRate":6.76},{"keyAreaName":"西虹桥","userNum":1195,"vacancyRate":6.87},{"keyAreaName":"先行启动区","userNum":6812,"vacancyRate":13.07}];
    // let typicalResidentialVacancyRate = [{"keyAreaName":"界泾港新村","userNum":0,"vacancyRate":0.00},{"keyAreaName":"桂花园","userNum":0,"vacancyRate":0.00},{"keyAreaName":"观湖御景","userNum":0,"vacancyRate":0.00},{"keyAreaName":"恒大御澜庭","userNum":0,"vacancyRate":0.00},{"keyAreaName":"崧泽华城","userNum":0,"vacancyRate":0.00},{"keyAreaName":"首创禧悦晴朗","userNum":0,"vacancyRate":0.00}];
    // let vacantHouseholdsInKeyAreas = [{"month":"202101","quantity":10.50},{"month":"202102","quantity":10.30},{"month":"202103","quantity":10.70},{"month":"202104","quantity":10.60},{"month":"202105","quantity":10.30},{"month":"202106","quantity":10.00},{"month":"202107","quantity":9.80},{"month":"202108","quantity":9.30},{"month":"202109","quantity":8.80},{"month":"202110","quantity":7.97},{"month":"202111","quantity":7.77},{"month":"202112","quantity":7.41},{"month":"202201","quantity":8.00},{"month":"202202","quantity":8.13},{"month":"202203","quantity":8.23},{"month":"202204","quantity":8.31},{"month":"202205","quantity":8.74},{"month":"202206","quantity":8.66}];
    // let typicalResidentialVacancyTrends = [];
    // let rangeData = {"regionalScope":"青浦区","timeRange":"2022年7月"};
    // ----------------test---------------------

    if (JSON.stringify(vacantHouseholdData) === '{}') vacantHouseholdData = {numberOfVacantHouseholds:0, chainRatio:0, yoy:0};
    if (JSON.stringify(housingVacancyRateData) === '{}') housingVacancyRateData = {housingVacancyRate:0, chainRatio:0, yoy:0};
    if (JSON.stringify(IdleUserPowerData) === '{}') IdleUserPowerData = {averagePowerConsumptionOfVacantUsers:0, chainRatio:0, yoy:0};
    if (JSON.stringify(rangeData) === '{}') rangeData = {regionalScope:"", timeRange:""};

    if (!vacantHouseholdData) throw new BizError(`${interfaceName} 缺少参数 vacantHouseholdData` );
    if (!housingVacancyRateData) throw new BizError(`${interfaceName} 缺少参数 housingVacancyRateData` );
    if (!IdleUserPowerData) throw new BizError(`${interfaceName} 缺少参数 IdleUserPowerData` );
    if (!qingPuDistrictHousingVacancyRateTrend) throw new BizError(`${interfaceName} 缺少参数 qingPuDistrictHousingVacancyRateTrend` );
    if (!housingVacancyRateInKeyAreas) throw new BizError(`${interfaceName} 缺少参数 housingVacancyRateInKeyAreas` );
    if (!typicalResidentialVacancyRate) throw new BizError(`${interfaceName} 缺少参数 typicalResidentialVacancyRate` );
    if (!vacantHouseholdsInKeyAreas) throw new BizError(`${interfaceName} 缺少参数 vacantHouseholdsInKeyAreas` );
    if (!typicalResidentialVacancyTrends) throw new BizError(`${interfaceName} 缺少参数 typicalResidentialVacancyTrends` );
    if (!rangeData) throw new BizError(`${interfaceName} 缺少参数 rangeData` );


    //空置户数据
    let {numberOfVacantHouseholds, chainRatio, yoy} = vacantHouseholdData;
    let vacantHouseholdInfo = {
        空置户数量: numberOfVacantHouseholds,
        环比: chainRatio,
        同比: yoy
    };

    //青浦区住房空置率趋势
    let qingPuDistrictHousing = {};
    qingPuDistrictHousingVacancyRateTrend.forEach( info => {
        let {month, quantity} = info;
        qingPuDistrictHousing[month] = quantity;
    });

    //重点区域住房空置率
    let housingVacancyInfo;
    let userNumData = {};
    let vacancyRateData = {};
    housingVacancyRateInKeyAreas.forEach( info => {
        let {keyAreaName, userNum, vacancyRate} = info;
        userNumData[keyAreaName] = userNum;
        vacancyRateData[keyAreaName] = vacancyRate;
    })
    housingVacancyInfo = {用户数: userNumData, 空置率: vacancyRateData};
    
    //范围数据
    let {regionalScope, timeRange} = rangeData;
    let rangeInfo = {
        "区域范围": regionalScope,
        "时间范围": timeRange
    };

    return {vacantHouseholdInfo, qingPuDistrictHousing, housingVacancyInfo, rangeInfo};
}

export async function getHousingVacancyRate() {
    let interfaceName = "住宅空置率";
    let zzkzlData = await getInterfaceByInterfaceName(interfaceName);
    // let zzkzlData:any = {housingVacancyRateData:{"housingVacancyRate":7.76,"yoy":-6.27,"chainRatio":-0.11}};

    // -------------------test------------------------
    if (JSON.stringify(zzkzlData.housingVacancyRateData) === '{}') zzkzlData.housingVacancyRateData = {housingVacancyRate:0, chainRatio:0, yoy:0};

    if (!zzkzlData.housingVacancyRateData) throw new BizError(`${interfaceName} 缺少参数 housingVacancyRateData` );
    
    //住房空置率数据
    let {housingVacancyRate, chainRatio, yoy} = zzkzlData.housingVacancyRateData;
    let housingVacancyRateInfo = {
        住房空置率: housingVacancyRate,
        环比: chainRatio,
        同比: yoy
    };

    return {housingVacancyRateInfo};
}

export async function getIdleUserPower() {
    let interfaceName = "住宅空置率";
    let zzkzlData = await getInterfaceByInterfaceName(interfaceName);
    // let zzkzlData:any = {IdleUserPowerData:{"averagePowerConsumptionOfVacantUsers":0.47,"yoy":4.44,"chainRatio":58.33}};

    // -------------------test------------------------
    if (JSON.stringify(zzkzlData.IdleUserPowerData) === '{}') zzkzlData.IdleUserPowerData = {averagePowerConsumptionOfVacantUsers:0, chainRatio:0, yoy:0};

    if (!zzkzlData.IdleUserPowerData) throw new BizError(`${interfaceName} 缺少参数 IdleUserPowerData` );
    
    //空置用户电量数据
    let {averagePowerConsumptionOfVacantUsers, chainRatio, yoy} = zzkzlData.IdleUserPowerData;
    let IdleUserPowerInfo = {
        空置用户平均电量: averagePowerConsumptionOfVacantUsers,
        环比: chainRatio,
        同比: yoy
    };

    return {IdleUserPowerInfo};
}

export async function getResidentialVacancyRate() {
    let interfaceName = "住宅空置率";
    let zzkzlData = await getInterfaceByInterfaceName(interfaceName);

    // -------------------test------------------------
    // let zzkzlData = {typicalResidentialVacancyRate:[{"keyAreaName":"界泾港新村","userNum":83,"vacancyRate":3.25},{"keyAreaName":"桂花园","userNum":18,"vacancyRate":2.41},{"keyAreaName":"观湖御景","userNum":66,"vacancyRate":37.71},{"keyAreaName":"恒大御澜庭","userNum":154,"vacancyRate":10.93},{"keyAreaName":"崧泽华城","userNum":1060,"vacancyRate":13.20},{"keyAreaName":"首创禧悦晴朗","userNum":422,"vacancyRate":13.89}]};

    if (!zzkzlData.typicalResidentialVacancyRate) throw new BizError(`${interfaceName} 缺少参数 typicalResidentialVacancyRate` );
    
    //典型小区住房空置率
    let residentialVacancyRate = zzkzlData.typicalResidentialVacancyRate;
    
    let residentialVacancyRateInfo;
    let userNumData = {};
    let vacancyRateData = {};
    residentialVacancyRate.forEach( info => {
        let {keyAreaName, userNum, vacancyRate} = info;
        userNumData[keyAreaName] = userNum;
        vacancyRateData[keyAreaName] = vacancyRate;
    })
    residentialVacancyRateInfo = {用户数: userNumData, 空置率: vacancyRateData};

    return {residentialVacancyRateInfo};
}

export async function getVacantHouseholdsInKeyAreas() {
    let interfaceName = "住宅空置率";
    let zzkzlData = await getInterfaceByInterfaceName(interfaceName);
    // let zzkzlData = {vacantHouseholdsInKeyAreas:[{"month":"202101","quantity":10.50},{"month":"202102","quantity":10.30},{"month":"202103","quantity":10.70},{"month":"202104","quantity":10.60},{"month":"202105","quantity":10.30},{"month":"202106","quantity":10.00},{"month":"202107","quantity":9.80},{"month":"202108","quantity":9.30},{"month":"202109","quantity":8.80},{"month":"202110","quantity":7.97},{"month":"202111","quantity":7.77},{"month":"202112","quantity":7.41},{"month":"202201","quantity":8.00},{"month":"202202","quantity":8.13},{"month":"202203","quantity":8.23},{"month":"202204","quantity":8.31},{"month":"202205","quantity":8.74},{"month":"202206","quantity":8.66}]};

    if (!zzkzlData.vacantHouseholdsInKeyAreas) throw new BizError(`${interfaceName} 缺少参数 vacantHouseholdsInKeyAreas` );

    //重点区域空置户趋势
    let vacantHouseholdsData = zzkzlData.vacantHouseholdsInKeyAreas;
    let vacantHouseholds = {};
    vacantHouseholdsData.forEach( info => {
        let {month, quantity} = info;
        vacantHouseholds[month] = quantity;
    });

    return {vacantHouseholds:{空置户趋势:vacantHouseholds}}
}

export async function getTypicalResidentialVacancyTrends() {
    let interfaceName = "住宅空置率";
    let zzkzlData = await getInterfaceByInterfaceName(interfaceName);
    // let zzkzlData = {typicalResidentialVacancyTrends:[{"month":"202101","quantity":13.80},{"month":"202102","quantity":14.00},{"month":"202103","quantity":14.50},{"month":"202104","quantity":17.60},{"month":"202105","quantity":17.00},{"month":"202106","quantity":17.40},{"month":"202107","quantity":16.90},{"month":"202108","quantity":15.10},{"month":"202109","quantity":14.30},{"month":"202110","quantity":18.49},{"month":"202111","quantity":18.23},{"month":"202112","quantity":17.00},{"month":"202201","quantity":11.23},{"month":"202202","quantity":10.56},{"month":"202203","quantity":10.98},{"month":"202204","quantity":11.13},{"month":"202205","quantity":11.62},{"month":"202206","quantity":11.30}]};

    if (!zzkzlData.typicalResidentialVacancyTrends) throw new BizError(`${interfaceName} 缺少参数 typicalResidentialVacancyTrends` );

    //典型小区空置户趋势
    let typicalResidential = zzkzlData.typicalResidentialVacancyTrends;
    let typicalResidentialVacancyTrends = {};
    typicalResidential.forEach( info => {
        let {month, quantity} = info;
        typicalResidentialVacancyTrends[month] = quantity;
    });

    return {typicalResidential:{空置户趋势:typicalResidentialVacancyTrends}};
}