import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

export async function getZhdy() {
    let interfaceName = "智慧电眼首页";
    let {basicData} = await getInterfaceByInterfaceName(interfaceName);

    // --------------test-------------
    // let basicData:any = {"economicSentimentIndex":103.6485,"suspectedShellCompanyRate":0.0000,"coordinatedDevelopmentOfCityClusters":0.0000,"pollutingEnterpriseProductionIndex":0.0000};
    // --------------end--------------

    if (JSON.stringify(basicData) === '{}') basicData = {economicSentimentIndex:0, suspectedShellCompanyRate:0, coordinatedDevelopmentOfCityClusters:0, pollutingEnterpriseProductionIndex:0};

    if (!basicData) throw new BizError(`${interfaceName} 缺少参数 basicData` );
    let {economicSentimentIndex, suspectedShellCompanyRate, coordinatedDevelopmentOfCityClusters, pollutingEnterpriseProductionIndex} = basicData;
    let basicInfo = {
        经济景气指数: economicSentimentIndex,
        疑似空壳企业率: suspectedShellCompanyRate + "%",
        城市协同发展指数: coordinatedDevelopmentOfCityClusters,
        污染企业生产指数: pollutingEnterpriseProductionIndex
    };

    return {basicInfo};
}
