import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

export async function getZdwrqysc() {
    let interfaceName = "重点污染企业生产";
    let {pollutingEnterprises, productionByPollutingEnterprises, pollutingType, pollutingEnterprisesTOP10, comparisonOfPollutionTypesIndex, industryTypePollutantEnterprise, pollutingCompaniesScatter, rangeData} = await getInterfaceByInterfaceName(interfaceName);
    
    // ------------------test----------------
    // let pollutingEnterprises:any = {"numPollutingEnterprises":48};
    // let productionByPollutingEnterprises:any = {};
    // let pollutingType:any = {};
    // let pollutingCompaniesScatter = [
    //     {
    //         "townName":"白鹤镇",
    //         "latitudeAndLongitude":[
    //             {"latitude":"31.266657","longitude":"121.086069","elevation":1.6424},
    //             {"latitude":"31.270797","longitude":"121.166599","elevation":1.24}
    //         ],
    //         "details":"白鹤镇， 重点污染企业2家，污染企业生产指数均值1.44。"
    //     },
    //     {
    //         "townName":"香花桥街道",
    //         "latitudeAndLongitude":[
    //             {"latitude":"31.211543","longitude":"121.139467","elevation":0.94},
    //             {"latitude":"31.173637","longitude":"121.182737","elevation":0.46124},
    //             {"latitude":"31.180212","longitude":"121.144456","elevation":1.04},
    //             {"latitude":"31.173885","longitude":"121.131135","elevation":0.924},
    //             {"latitude":"31.191047","longitude":"121.115028","elevation":1.13},
    //             {"latitude":"31.197253","longitude":"121.104266","elevation":1.15},
    //             {"latitude":"31.183733","longitude":"121.089807","elevation":1.13},
    //             {"latitude":"31.174851","longitude":"121.145911","elevation":0.974},
    //             {"latitude":"31.179632","longitude":"121.141999","elevation":1.15},
    //             {"latitude":"31.179104","longitude":"121.157998","elevation":1.16},
    //             {"latitude":"31.184298","longitude":"121.163384","elevation":1.00},
    //             {"latitude":"31.189716","longitude":"121.185462","elevation":1.67},
    //             {"latitude":"31.192941","longitude":"121.113608","elevation":1.01},
    //             {"latitude":"31.183428","longitude":"121.140802","elevation":1.46},
    //             {"latitude":"31.197085","longitude":"121.115385","elevation":1.35},
    //             {"latitude":"31.179563","longitude":"121.147635","elevation":1.14},
    //             {"latitude":"31.182979","longitude":"121.15726","elevation":1.29},
    //             {"latitude":"31.205627","longitude":"121.089477","elevation":0.94},
    //             {"latitude":"31.186274","longitude":"121.129743","elevation":0.9714},
    //             {"latitude":"31.196613","longitude":"121.097515","elevation":1.12},
    //             {"latitude":"31.185022","longitude":"121.166639","elevation":1.89},
    //             {"latitude":"31.192167","longitude":"121.162839","elevation":1.25},
    //             {"latitude":"31.186868","longitude":"121.164013","elevation":0.87},
    //             {"latitude":"31.184528","longitude":"121.160732","elevation":1.57},
    //             {"latitude":"31.194652","longitude":"121.100861","elevation":0.99},
    //             {"latitude":"31.167901","longitude":"121.180506","elevation":1.43},
    //             {"latitude":"31.202596","longitude":"121.136397","elevation":2.00},
    //             {"latitude":"31.183916","longitude":"121.130074","elevation":1.28},
    //             {"latitude":"31.192021","longitude":"121.127636","elevation":1.05},
    //             {"latitude":"31.203943","longitude":"121.162891","elevation":1.12},
    //             {"latitude":"31.206186","longitude":"121.10512","elevation":1.07}
    //         ],
    //         "details":"香花桥街道， 重点污染企业31家，污染企业生产指数均值1.1780645161290322。"
    //     },
    //     {
    //         "townName":"重固镇",
    //         "latitudeAndLongitude":[
    //             {"latitude":"31.188501","longitude":"121.147085","elevation":0.794},
    //             {"latitude":"31.197256","longitude":"121.207261","elevation":0.96}
    //         ],
    //         "details":"重固镇， 重点污染企业2家，污染企业生产指数均值0.875。"
    //     },
    //     {
    //         "townName":"华新镇",
    //         "latitudeAndLongitude":[
    //             {"latitude":"31.248519","longitude":"121.211189","elevation":2.457},
    //             {"latitude":"31.226913","longitude":"121.222196","elevation":0.964},
    //             {"latitude":"31.260512","longitude":"121.216928","elevation":1.662},
    //             {"latitude":"31.221565","longitude":"121.224518","elevation":1.19},
    //             {"latitude":"31.252542","longitude":"121.228505","elevation":0.97},
    //             {"latitude":"31.206301","longitude":"121.241209","elevation":1.01}
    //         ],
    //         "details":"华新镇， 重点污染企业6家，污染企业生产指数均值1.3733333333333333。"},
    //         {
    //             "townName":"赵巷镇 ",
    //             "latitudeAndLongitude":[
    //                 {"latitude":"31.169266","longitude":"121.17625","elevation":1.16}
    //             ],
    //             "details":"赵巷镇 ， 重点污染企业1家，污染企业生产指数均值1.16。"
    //         },
    //         {
    //             "townName":"途径镇",
    //             "latitudeAndLongitude":[
    //                 {"latitude":"31.201733","longitude":"121.266035","elevation":1.04},
    //                 {"latitude":"31.188779","longitude":"121.273566","elevation":0.94},
    //                 {"latitude":"31.161304","longitude":"121.266217","elevation":0.98}
    //             ],
    //             "details":"途径镇， 重点污染企业3家，污染企业生产指数均值0.9866666666666667。"
    //         },
    //         {
    //             "townName":"盈浦街道",
    //             "latitudeAndLongitude":[],
    //             "details":"盈浦街道， 重点污染企业0家。"
    //         },
    //         {
    //             "townName":"夏阳街道",
    //             "latitudeAndLongitude":[],
    //             "details":"夏阳街道， 重点污染企业0家。"
    //         },
    //         {
    //             "townName":"朱家角镇",
    //             "latitudeAndLongitude":[
    //                 {"latitude":"31.108307","longitude":"121.065882","elevation":1.58}
    //             ],
    //             "details":"朱家角镇， 重点污染企业1家，污染企业生产指数均值1.58。"
    //         },
    //         {
    //             "townName":"金泽镇",
    //             "latitudeAndLongitude":[],
    //             "details":"金泽镇， 重点污染企业0家。"
    //         },
    //         {
    //             "townName":"练塘镇",
    //             "latitudeAndLongitude":[
    //                 {"latitude":"31.001108","longitude":"121.073762","elevation":1.02},
    //                 {"latitude":"31.009611","longitude":"121.04397","elevation":1.12}
    //             ],
    //             "details":"练塘镇， 重点污染企业2家，污染企业生产指数均值1.07。"
    //         }
    //     ];
    // let pollutingEnterprisesTOP10 = [
    //     {companyName:"上海山崎电路板有限公司", value:"2.24"},
    //     {companyName:"上海山崎电路板上海朱家角污水处理工程建设有限公司", value:"1.52"},
    //     {companyName:"有限公司1", value:"2.24"},
    //     {companyName:"有限公司2", value:"1.52"},
    //     {companyName:"有限公司3", value:"2.24"},
    //     {companyName:"有限公司4", value:"1.52"},
    //     {companyName:"有限公司5", value:"2.24"},
    //     {companyName:"有限公司6", value:"1.52"},
    //     {companyName:"有限公司7", value:"2.24"},
    //     {companyName:"有限公司8", value:"1.52"},
    // ];
    // let comparisonOfPollutionTypesIndex = [{"pollutionType":"大气污染","numberOfPollutingCompanies":0,"productionIndex":0.00},{"pollutionType":"土壤污染","numberOfPollutingCompanies":0,"productionIndex":0.00},{"pollutionType":"水污染","numberOfPollutingCompanies":0,"productionIndex":0.00},{"pollutionType":"危险废物","numberOfPollutingCompanies":0,"productionIndex":0.00},{"pollutionType":"其他","numberOfPollutingCompanies":0,"productionIndex":0.00}];
    // let industryTypePollutantEnterprise = [{"industryType":"电力行业","numberOfPollutingCompanies":3,"productionIndex":1.00},{"industryType":"电子行业","numberOfPollutingCompanies":4,"productionIndex":1.30},{"industryType":"纺织行业","numberOfPollutingCompanies":1,"productionIndex":0.60},{"industryType":"机械行业","numberOfPollutingCompanies":5,"productionIndex":0.90},{"industryType":"批发和零售业","numberOfPollutingCompanies":14,"productionIndex":1.30},{"industryType":"汽车行业","numberOfPollutingCompanies":9,"productionIndex":0.30},{"industryType":"轻工行业","numberOfPollutingCompanies":10,"productionIndex":2.00},{"industryType":"石化行业","numberOfPollutingCompanies":11,"productionIndex":0.70},{"industryType":"水煤燃气","numberOfPollutingCompanies":3,"productionIndex":0.7},{"industryType":"医药行业","numberOfPollutingCompanies":6,"productionIndex":0.35},{"industryType":"有色行业","numberOfPollutingCompanies":15,"productionIndex":1.00}];
    // let rangeData = {regionalScope:"", timeRange:""};
    // -----------------end-------------------

    if (JSON.stringify(pollutingEnterprises) === '{}') pollutingEnterprises = {numPollutingEnterprises:0};
    if (JSON.stringify(productionByPollutingEnterprises) === '{}') productionByPollutingEnterprises = {pollutingEnterprisesIndex:0};
    if (JSON.stringify(pollutingType) === '{}') pollutingType = {waterPollution:0, hazardousWaste:0, airPollution:0, soilPollution:0, otherHighlights:0};
    if (JSON.stringify(rangeData) === '{}') rangeData = {regionalScope:"", timeRange:""};

    if (!pollutingEnterprises) throw new BizError(`${interfaceName} 缺少参数 pollutingEnterprises` );
    if (!productionByPollutingEnterprises) throw new BizError(`${interfaceName} 缺少参数 productionByPollutingEnterprises` );
    if (!pollutingType) throw new BizError(`${interfaceName} 缺少参数 pollutingType` );
    if (!pollutingEnterprisesTOP10) throw new BizError(`${interfaceName} 缺少参数 pollutingEnterprisesTOP10` );
    if (!comparisonOfPollutionTypesIndex) throw new BizError(`${interfaceName} 缺少参数 comparisonOfPollutionTypesIndex` );
    if (!industryTypePollutantEnterprise) throw new BizError(`${interfaceName} 缺少参数 industryTypePollutantEnterprise` );
    if (!pollutingCompaniesScatter) throw new BizError(`${interfaceName} 缺少参数 pollutingCompaniesScatter` );
    if (!rangeData) throw new BizError(`${interfaceName} 缺少参数 rangeData` );

    //污染企业数据
    let pollutingInfo = {污染企业总数: pollutingEnterprises.numPollutingEnterprises};

    //污染企业生产数据
    let productionInfo = {污染企业生产指数: productionByPollutingEnterprises.pollutingEnterprisesIndex};

    //污染类型
    let {waterPollution, hazardousWaste, airPollution, soilPollution, otherHighlights} = pollutingType;
    let pollutingTypeInfo = {
        水污染: waterPollution,
        危险污染: hazardousWaste,
        大气污染: airPollution,
        土壤污染: soilPollution,
        其他重点: otherHighlights    
    };

    //污染企业TOP10
    let pollutingTop10 = {};
    pollutingEnterprisesTOP10.forEach( info => {
        let {companyName, value} = info;
        pollutingTop10[companyName] = value;
    })

    //各污染类型企业生产指数对比
    let pollutionTypeInfo;
    let numberOfPollutingCompaniesData = {};
    let productionIndexData = {};
    comparisonOfPollutionTypesIndex.forEach( info => {
        let {pollutionType, numberOfPollutingCompanies, productionIndex} = info;
        numberOfPollutingCompaniesData[pollutionType] = numberOfPollutingCompanies;
        productionIndexData[pollutionType] = productionIndex;
    })
    pollutionTypeInfo = {污染企业数: numberOfPollutingCompaniesData, 生产指数: productionIndexData};

    //各行业类型污染企业生产指数对比
    let industryTypeInfo;
    let numberOfPollutingData = {};
    let productionData = {};
    industryTypePollutantEnterprise.forEach( info => {
        let {industryType, numberOfPollutingCompanies, productionIndex} = info;
        numberOfPollutingData[industryType] = numberOfPollutingCompanies;
        productionData[industryType] = productionIndex;
    })
    industryTypeInfo = {污染企业数: numberOfPollutingData, 生产指数: productionData};

    //范围数据
    let {regionalScope, timeRange} = rangeData;
    let rangeInfo = {
        "区域范围": regionalScope,
        "时间范围": timeRange
    };

    return {pollutingInfo, productionInfo, pollutingTypeInfo, pollutionTypeInfo, pollutingTop10, industryTypeInfo, pollutingCompaniesScatter, rangeInfo}
}