import { BizError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "./cronJob";

export async function getYskkqyjc() {
    let interfaceName = "疑似空壳企业监测";
    let {basicData, enterpriseDistributionDifferentCapacities, industrialDistribution, changesNumberShellCompanies, changesTrendShellCompanies, rangeData} = await getInterfaceByInterfaceName(interfaceName);
    
    // ----------------test----------------
    // let basicData:any = {"numberOfShellEnterprises":454,"suspectedShellRate":10.09};
    // let enterpriseDistributionDifferentCapacities:any = {"within100":21,"mithin315":377,"more315":56};
    // let industrialDistribution:any = {"fisheries":11,"industrial":59,"transportationAndWarehousingAndPostalServices":1,"informationTechnologyServices":1,"wholesaleAndRetail":14,"financialIndustry":1,"realEstate":341,"leasingAndBusinessService":6,"publicServiceAndManagementOrganization":20};
    // let changesNumberShellCompanies = [{"year":"2018","numberOfShellCompanies":308},{"year":"2019","numberOfShellCompanies":351},{"year":"2020","numberOfShellCompanies":394},{"year":"2021","numberOfShellCompanies":432},{"year":"2022","numberOfShellCompanies":454}];
    // let changesTrendShellCompanies = [{"year":"2018","changeTrend":8.87},{"year":"2019","changeTrend":8.89},{"year":"2020","changeTrend":9.76},{"year":"2021","changeTrend":9.80},{"year":"2022","changeTrend":10.09}];
    // ---------------end-------------------

    if (JSON.stringify(basicData) === '{}') basicData = {numberOfShellEnterprises:0, suspectedShellRate:0};
    if (JSON.stringify(enterpriseDistributionDifferentCapacities) === '{}') enterpriseDistributionDifferentCapacities = {within100:0, mithin315:0, more315:0};
    if (JSON.stringify(industrialDistribution) === '{}') industrialDistribution = {fisheries:0, industrial:0, transportationAndWarehousingAndPostalServices:0, informationTechnologyServices:0, wholesaleAndRetail:0, realEstate:0, leasingAndBusinessService:0, publicServiceAndManagementOrganization:0, constructionIndustry:0};
    if (JSON.stringify(rangeData) === '{}') rangeData = {regionalScope:"", timeRange:""};

    if (!basicData) throw new BizError(`${interfaceName} 缺少参数 basicData` );
    if (!enterpriseDistributionDifferentCapacities) throw new BizError(`${interfaceName} 缺少参数 enterpriseDistributionDifferentCapacities` );
    if (!industrialDistribution) throw new BizError(`${interfaceName} 缺少参数 industrialDistribution` );
    if (!changesNumberShellCompanies) throw new BizError(`${interfaceName} 缺少参数 changesNumberShellCompanies` );
    if (!changesTrendShellCompanies) throw new BizError(`${interfaceName} 缺少参数 changesTrendShellCompanies` );
    if (!rangeData) throw new BizError(`${interfaceName} 缺少参数 rangeData` );
    
    let {numberOfShellEnterprises, suspectedShellRate} = basicData;
    let basicInfo = {
        疑似空壳企业数: numberOfShellEnterprises,
        疑似空壳率: suspectedShellRate
    };

    //不同容量疑似空壳企业分布
    let {within100, mithin315, more315} = enterpriseDistributionDifferentCapacities;
    let enterpriseDistribution = {
        '0-100kvA': within100,
        '101-315kvA': mithin315,
        '315kvA以上': more315
    };

    //行业疑似空壳企业分布
    let {fisheries, industrial, transportationAndWarehousingAndPostalServices, informationTechnologyServices, wholesaleAndRetail, realEstate, 
        leasingAndBusinessService, publicServiceAndManagementOrganization, constructionIndustry} = industrialDistribution;
    
    let industrialInfo = {
        '农、林、牧、渔业': fisheries,
        '工业': industrial,
        '交通运输、仓储和邮政服务': transportationAndWarehousingAndPostalServices,
        '信息技术服务业': informationTechnologyServices,
        '批发和零售业': wholesaleAndRetail,
        '房地产业': realEstate,
        '租赁和商务服务业': leasingAndBusinessService,
        '公共服务及管理组织': publicServiceAndManagementOrganization,
        '金融业': constructionIndustry
    };
    
    //疑似空壳企业数变化趋势
    let changesNumberInfo = {};
    changesNumberShellCompanies.forEach( info => {
        let {year, numberOfShellCompanies} = info;
        changesNumberInfo[year] =  numberOfShellCompanies;
    })

    //疑似空壳企业空壳率变化趋势
    let changesTrendShellInfo = {};
    changesTrendShellCompanies.forEach( info => {
        let {year, changeTrend} = info;
        changesTrendShellInfo[year] = changeTrend;
    })

    //范围数据
    let {regionalScope, timeRange} = rangeData;
    let rangeInfo = {
        "区域范围": regionalScope,
        "时间范围": timeRange
    };

    return {basicInfo, enterpriseDistribution, industrialInfo, changesNumberInfo, changesTrendShellInfo, rangeInfo};
}